//	Critical Mass
//	13/7/1997
//	Hamish Carr
//	CMassView.h

#include "CMassView.h"
#define CELL_SIZE 64
//
//char *HumanWinsSound = "CM Sounds/HumanWins.au";
//char *ComputerWinsSound = "CM Sounds/ComputerWins.au";
//char *Player1BoomSound = "CM Sounds/Player1Boom.au";
//char *Player2BoomSound = "CM Sounds/Player2Boom.au";
//char *ExitSound = "CM Sounds/Exit.au";

#define DISPLAYBOARDSEMNAME "CM Display Board Sem"
#define DISPLAYSEMNAME "CM Display Sem"
#define MOUSESEMNAME "CM Mouse Sem"
#define TURNSEMNAME "CM Turn Sem"
#define THINKINGSEMNAME "CM Rodin the Thinking Sem"
#define STATUSSEMNAME "CM JonesKeeper"

CMassView::CMassView(BRect rect, char *name)
	   	   : BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW)
{
long i;																//	loop index
BRect theRect;														//	for setting the size of pictures
app_info CMAppInfo;													//	used for finding where the application is
BEntry CMEntry;														//	entry in database representing the app
BFile CMFile;														//	the CMass application file
BResources CMResources;												//	the CMass resources
status_t errorCode;													//	used for checking success
void *aPICT;														//	a picture loaded - typed void b/c picH is a Mac type
size_t pictLength;													//	length of the pict in bytes

//	load in the pictures

//	initialize array & rectangle

theRect.Set(0, 0, 63, 63);											//	set dimensions of the PICT's
for (i = 0; i < N_BITMAPS; i++)										//	initialize array to NULLs
	theBitmaps[i] = NULL;											//	one at a time

//	find the file in the database
be_app->GetAppInfo(&CMAppInfo);										//	ask our global app to tell us where it is
errorCode = CMEntry.SetTo(&CMAppInfo.ref);							//	convert this to a database entry
if (errorCode != B_NO_ERROR)										//	if that didn't work
	cMass->FatalErrorAlert(DIE_BAD_ENTRY);							//	die gracefully
errorCode = CMFile.SetTo(&CMEntry, B_READ_ONLY);					//	open it in read-only mode
if (errorCode != B_NO_ERROR)										//	if that didn't work
	cMass->FatalErrorAlert(DIE_BAD_FILE);							//	die gracefully
errorCode = CMResources.SetTo(&CMFile);								//	open the resources
if (errorCode != B_NO_ERROR)										//	if that didn't work
	cMass->FatalErrorAlert(DIE_BAD_RESOURCES);						//	die gracefully
for (i = 0; i < N_BITMAPS; i++)										//	walk through, reading in PICTs
	{
	aPICT = CMResources.FindResource('PICT', i+1000, &pictLength);	//	retrieve the picture
	if (aPICT != NULL)												//	i.e. it was successful
		{
		theBitmaps[i] = new BBitmap(theRect, B_COLOR_8_BIT);		//	make a new bitmap with it
		theBitmaps[i]->SetBits(aPICT, pictLength, 0, B_COLOR_8_BIT);//	and set the pixels
		free(aPICT);												//	free up the memory
		} // end of aPICT != NULL
	else															//	oops, it doesn't exist
		cMass->FatalErrorAlert(DIE_BAD_PICT);//	die gracefully
	} // end of for i = 0 to 12
	
displayBoardSemaphore = new CMSemaphore(DISPLAYBOARDSEMNAME);		//	initialize our semaphores
displaySemaphore = new CMSemaphore(DISPLAYSEMNAME);				
mouseSemaphore = new CMSemaphore(MOUSESEMNAME);
turnSemaphore = new CMSemaphore(TURNSEMNAME);
thinkingSemaphore = new CMSemaphore(THINKINGSEMNAME);	
	
theRect.Set(0, 320, 383, 350);										//	set the rect size for status bar
theStatusBar = new BStatusBar(theRect, "GedankenBar", NULL, NULL);
																	//	create the status bar
theStatusBar->SetMaxValue(30.0);									//	set the maximum size of the bar
AddChild(theStatusBar);												//	connect up the status bar

theBrain = NULL;													//	create a null brain so NewGame() works
redPlayerType = HUMAN_PLAYER;										//	set the player types
bluePlayerType = RANDOM_PLAYER;		
NewGame(false);														//	call the routine to start new game		
displaySpeed = MEDIUM_SPEED;										//	set to medium speed
soundOn = true;														//	and quiet
speedID = OptionMediumDisplayItem;									//	set the speed option	
displayOnNextPulse = false;											//	start off with no display pending
SetFlags(Flags() | B_PULSE_NEEDED);									//	turn pulses on
thoughtPriority = B_LOW_PRIORITY;									//	set the priority
} // end of constructor

void CMassView::Draw(BRect)
{
int i,j;															//	loop indices
BPoint start(0,0), end(384,0);										//	initialize two points
BPoint BombPoint;													//	where to draw the bomb
long nBombs;														//	the number of bombs in a cell
		
displayBoardSemaphore->Acquire();									//	acquire the semaphore for access to displayBoard
for (i = 1; i <= N_ROWS; i++)										//	loop down the rows
	{
	for (j = 1; j <= N_COLS; j++)									//	walk down the columns
		{
		BombPoint.Set((j-1)*CELL_SIZE, (i-1)*CELL_SIZE);
		MovePenTo(BombPoint);										//	move the pen into place
		nBombs = theDisplayBoard->Bombs(i,j);
		nBombs += CELL_EMPTY;
		DrawBitmap(theBitmaps[nBombs]);
		} // end of for j loop
	} // end of for i loop	
displayBoardSemaphore->Release();									//	release the semaphore for access to displayBoard
} // end of Draw()


void CMassView::MouseDown(BPoint where)								//	routine to process mouse down events
{
long row, col;														//	the board coordinates of the click

mouseSemaphore->Acquire();											//	acquire the semaphore for this function

busyWithMouseDown = true;											//	now we're busy with a mouseDown
if (mouse_moves_allowed)											//	if it is OK to move
	{
	if (!gameOver)													//	if the game isnt over yet
		{
		row = (where.y + CELL_SIZE - 1) / CELL_SIZE;				//	calculate which row to look in
		col = (where.x + CELL_SIZE - 1) / CELL_SIZE;

		if (row < 1) row = 1;										//	make sure it is a legal cell
		else if (row > N_ROWS) row = N_ROWS;
		if (col < 1) col = 1;
		else if (col > N_COLS) col = N_COLS;

		if (thePlayer == RED_PLAYER)								//	one case for each player
			{
			if (theBoard->Bombs(row, col) <= 0)						//	if it's a legal red move
				{
				turnSemaphore->Acquire();							//	acquire the semaphore for changing turn data
				mouse_moves_allowed = false;						//	make sure we can't do another (reset by Pulse())
				theBoard->MoveRed(row, col);						//	update the "real" board
				gameOver = ((theBoard->Evaluate() == BLUE_WIPED_OUT) && (gameTurn > 2));
																	//	set the flag for end of game
				StartDisplayThread(row, col);						//	display the execution
				SwitchPlayers();									//	call routine to start next turn
				turnSemaphore->Release();							//	and release it
				}			
			} // necessary braces to resolve ambiguous if if else
		else if (thePlayer == BLUE_PLAYER)							//	blue player
			{
			if (theBoard->Bombs(row, col) >= 0)						//	if it's a legal blue move
				{
				turnSemaphore->Acquire();							//	acquire the semaphore for changing turn data
				mouse_moves_allowed = false;						//	make sure we can't do another (reset by Pulse())
				theBoard->MoveBlue(row, col);						//	update the board
				gameOver = ((theBoard->Evaluate() == RED_WIPED_OUT) && (gameTurn > 2));
																	//	set the flag for end of game
				StartDisplayThread(row, col);						//	display the execution
				SwitchPlayers();									//	call routine to start next turn
				turnSemaphore->Release();							//	and release it
				}			
			} // necessary braces to resolve ambiguous if if else
		else // i.e. neither red nor blue	
			cMass->FatalErrorAlert(DIE_BAD_PLAYER);					//	die gracefully
		} // end of !gameOver
	} // end of OK_to_move

busyWithMouseDown = false;											//	say that we are no longer busy	
mouseSemaphore->Release();											//	release the semaphore for this function
} // end of MouseDown()

void CMassView::StartDisplayThread(long row, long col)				//	display a move's execution
{
displaySemaphore->Acquire();										//	acquire mutex semaphore for this function
																	//	note that it is not released in this function
																	//	it will be released at the end of the display thread
// set some data for the threaded display
display_row = row; display_col = col; display_player = thePlayer;	//	this will allow us to start thinking of the next move

displayDone = false;												//	mark the display routine as uncompleted
displayThread = spawn_thread(Display_Move, "CM Exhibitionist", B_NORMAL_PRIORITY, this);
																	//	spawn a thread to do the work for us
if ((displayThread == B_NO_MORE_THREADS) || 						//	if there isn't a spare thread ID
	(displayThread == B_NO_MEMORY))									//	or there isn't enough memory for a thread
	cMass->FatalErrorAlert(DIE_NO_DISPLAY_THREAD);					//	die gracefully

if(resume_thread(displayThread) != B_NO_ERROR)						//	if the resume call failed
	cMass->FatalErrorAlert(DIE_RESUME_DISPLAY_FAILED);				//	also die gracefully
} // end of StartDisplayThread()

void CMassView::DisplayMove()										//	the routine that actually does the display
{
if (display_player == RED_PLAYER)									//	if the player to move is red
	{
	theDisplayBoard->MoveRed(display_row, display_col, *this);		//	call the routine to do the display
	displayOnNextPulse = true;										//	set the flag to display it
	if (gameOver)													//	if it was a winning move
		winner = RED_PLAYER;										//	set the winner
	} // end of red display
else // i.e. blue player
	{
	theDisplayBoard->MoveBlue(display_row, display_col, *this);		//	call the routine to do the display
	displayOnNextPulse = true;										//	set the flag to display it

	if (gameOver)													//	if it was a winning move
		winner = BLUE_PLAYER;										//	set the winner
	} // end of blue display

displayDone = true;													//	set the flag to say that we are done
displaySemaphore->Release();										//	allow the next display call through
} // end of DisplayMove()

int32 CMassView::Display_Move(void *arg)							//	static function to start thread
{
CMassView *theCMassView = (CMassView *) arg;						//	type cast it to a CMassView object
theCMassView->DisplayMove();										//	run the function that does the display
return 0;															//	return a happy camper code
}

void CMassView::StartThinkingThread()								//	think up a move
{
thinkingSemaphore->Acquire();										//	acquire mutex semaphore for this function
																	//	note that it is not released in this function
																	//	it will be released at the end of the thinking thread
theStatusBar->Reset();												//	make sure it's reset
// set some data for the threaded display
thinkingUpMove = true;												//	we are busy thinking up a move
thinkingThread = spawn_thread(Think_Up_Move, "CM Rodin the Thinker", B_NORMAL_PRIORITY, this);
																	//	spawn a thread to do the work for us
if ((thinkingThread == B_NO_MORE_THREADS) || 						//	if there isn't a spare thread ID
	(thinkingThread == B_NO_MEMORY))								//	or there isn't enough memory for a thread
	cMass->FatalErrorAlert(DIE_NO_THINKING_THREAD);					//	die gracefully

if(resume_thread(thinkingThread) != B_NO_ERROR)						//	if the resume call failed
	cMass->FatalErrorAlert(DIE_RESUME_THINKING_FAILED);				//	also die gracefully
} // end of StartDisplayThread()

void CMassView::ThinkUpMove()										//	the routine that thinks up a move
{
int row, col;														//	coordinates for the computer's move
status_t display_return_value;										//	needed to wait for display thread

if (thePlayer == RED_PLAYER)										//	if the player to move is red
	{
	theBrain = new CMBrain;											//	create a brain
	switch (redPlayerType)											//	and depending on what you see
		{
		case BILL_KOCAY_PLAYER:										//	do a level 4 lookahead
			theBrain->ThreadedMinMaxRed(theBoard, &row, &col, 4, theStatusBar, gameTurn == 1);			
			break;
		case AI_PLAYER:												//	do a level 2 lookahead
			theBrain->MinMaxRed(theBoard, &row, &col, 2, theStatusBar, gameTurn == 1);
			break;
		case SMART_PLAYER:											//	a smart player
			theBrain->SmartRed(theBoard, &row, &col, gameTurn == 1);//	come up with a smart move
			break;
		default:													//	default case
			theBrain->RandomRed(theBoard, &row, &col);				//	generate a move
		} // end of switch statement
	
	wait_for_thread(displayThread, &display_return_value);			//	make sure that the display thread is dead
	turnSemaphore->Acquire();										//	acquire the semaphore for changing turn data
	mouse_moves_allowed = false;									//	make sure we can't do another (reset at end of DisplayMove)
	theBoard->MoveRed(row, col);									//	update the "real" board
	gameOver = ((theBoard->Evaluate() == BLUE_WIPED_OUT) && (gameTurn > 2));
																	//	set the flag for end of game
	StartDisplayThread(row, col);									//	display the execution
	SwitchPlayers();												//	call routine to start next turn
	turnSemaphore->Release();										//	and release it
	} // end of red move
else // i.e. blue player
	{
	theBrain = new CMBrain;											//	create a brain
	switch (bluePlayerType)											//	and depending on what you see
		{
		case BILL_KOCAY_PLAYER:										//	do a level 4 lookahead
			theBrain->ThreadedMinMaxBlue(theBoard, &row, &col, 4, theStatusBar);				
			break;
		case AI_PLAYER:
			theBrain->MinMaxBlue(theBoard, &row, &col, 2, theStatusBar);
																	//	do a level 2 lookahead
			break;
		case SMART_PLAYER:											//	a smart player
			theBrain->SmartBlue(theBoard, &row, &col);				//	come up with a smart move
			break;
		default:													//	default case
			theBrain->RandomBlue(theBoard, &row, &col);				//	generate a move
		} // end of switch statement
	wait_for_thread(displayThread, &display_return_value);			//	make sure that the display thread is dead
	turnSemaphore->Acquire();										//	acquire the semaphore for changing turn data
	mouse_moves_allowed = false;									//	make sure we can't do another (reset at end of DisplayMove)
	theBoard->MoveBlue(row, col);									//	update the "real" board
	gameOver = ((theBoard->Evaluate() == RED_WIPED_OUT) && (gameTurn > 2));
																	//	set the flag for end of game
	StartDisplayThread(row, col);									//	display the execution
	SwitchPlayers();												//	call routine to start next turn
	turnSemaphore->Release();										//	and release it
	} // end of blue display
thinkingUpMove = false;												//	we are no longer thinking up a move
thinkingSemaphore->Release();										//	release the semaphore for the thinking thread;
}; // end of ThinkUpMove()

int32 CMassView::Think_Up_Move(void *arg)							//	static function to start thread
{
CMassView *theCMassView = (CMassView *) arg;						//	type cast it to a CMassView object
theCMassView->ThinkUpMove();										//	run the function that does the display
return 0;															//	return a happy camper code
} // end of Think_Up_Move()

void CMassView::Pulse()												//	the pulse routine
	{
	if (atomic_and(&displayOnNextPulse, false))						//	test and set to false
		Draw(Frame());												//	redraw the display
	else if (gameOver && winner != NEITHER_PLAYER)					//	if that move won
		{
		if (soundOn)												//	if sound was switched on
			cMass->theSounds[GAME_OVER_SOUND]->Play();				//	play a big sound
		BAlert *victoryAlert;										// 	declare an alert
		victoryAlert = new BAlert("Critical Mass Victory", 
									winner == RED_PLAYER ? 	"Red Player Won!\n\nChoose New Game to restart" :
															"Blue Player Won!\n\nChoose New Game to restart"
									, "OK", NULL, NULL, 
									B_WIDTH_AS_USUAL, B_INFO_ALERT);
																	//	set the alert up
		BRect windowRect = Window()->Frame();						//	find the screen coords of the parent window
		BRect viewRect = Frame();									//	find the frame for the view
		BRect alertRect = victoryAlert->Frame();					//	find the frame for the alert
		alertRect.left = windowRect.left + viewRect.left + ((viewRect.right - viewRect.left) - (alertRect.right - alertRect.left))/2;
		alertRect.top = windowRect.top + viewRect.top + ((viewRect.bottom - viewRect.top) - (alertRect.bottom - alertRect.top))/2;
																	//	centre the alert in the view
		victoryAlert->MoveTo(alertRect.left, alertRect.top);		//	move the alert correspondingly
		victoryAlert->Go();											//	run it & wait for it to return
		winner = NEITHER_PLAYER;									//	reset the winner
		} // end of test for end of game

	if (!thePlayerIsHuman && !gameOver && !thinkingUpMove)			//	if the player isn't a human player
		{
		StartThinkingThread();										//	think up a move for the computer
		}
	if (thePlayerIsHuman && !gameOver && !mouse_moves_allowed && !busyWithMouseDown && displayDone)
		{															//	if a human is blocked from moving
		mouseSemaphore->Acquire();									//	acquire the mouse semaphore
		if (thePlayerIsHuman && !gameOver && !mouse_moves_allowed && !busyWithMouseDown && displayDone)
																	//	make sure these are still the case
																	//	because Acquisition can take a while
																	//	and we want Pulse operative while MouseDown is active
			mouse_moves_allowed = true;								//	set it to true
		mouseSemaphore->Release();									//	release the semaphore
		} // end of if thePlayerIsHuman
	} // end of Pulse()

void CMassView::SwitchPlayers()										//	switches the turns of the players
{ 
if (thePlayer == RED_PLAYER)										//	one case at a time
	{
	thePlayer = BLUE_PLAYER;										//	switch player
	thePlayerIsHuman = (bluePlayerType == HUMAN_PLAYER);			//	set whether the player is human
	gameTurn++;														//	increment the game turn							
	} // end of red -> blue switch
else // i.e. blue player
	{
	thePlayer = RED_PLAYER;											//	switch player
	thePlayerIsHuman = (redPlayerType == HUMAN_PLAYER);				//	set whether the player is human
	gameTurn++;														//	increment the game turn							
	} // end of blue -> red switch
}

void CMassView::ShowBoard(											//	shows the current board
	int whichPlayer, 												//	whose move it just was
	bool explosion)													//	whether there are explosions
{
displayOnNextPulse = true;											//	set displayOnNextPulse to true

if (explosion && soundOn)											//	if there was an explosion
	if (whichPlayer == RED_PLAYER)									//	and we have the red player
		{
		cMass->theSounds[BOOM_1_SOUND]->Play();						//	play a boom sound
		}
	else
		{
		cMass->theSounds[BOOM_2_SOUND]->Play();						//	play a different boom sound
		}
} // end of ShowBoard()

void CMassView::SetPlayerType(int player, int playerType)			//	set the type of a given player
	{
	if (player == RED_PLAYER)										//	if the player passed is red
		{
		if ((redPlayerType == HUMAN_PLAYER) && 						//	we were human, and have switched to computer
			(playerType != HUMAN_PLAYER)&&		
			(thePlayer == player) &&								//	and it is this player's turn		
			(mouse_moves_allowed))									//	i.e. we are waiting for a human mouse click
			{
			mouseSemaphore->Acquire();								//	acquire the mouse semaphore
			mouse_moves_allowed = false;							//	prohibit mouse moves
			mouseSemaphore->Release();								//	release the mouse semaphore
			turnSemaphore->Acquire();								//	acquire the turn semaphore
			thePlayerIsHuman = false;								//	mark it as no longer human (force it to think)
			turnSemaphore->Release();								//	release the turn semaphore
			} 
		redPlayerType = playerType;									//	set the new type (as of next move)
		} // end of red player
	else
		{ // blue player
		if ((bluePlayerType == HUMAN_PLAYER) && 					//	we were human, and have switched to computer
			(playerType != HUMAN_PLAYER)&&		
			(thePlayer == player) &&								//	and it is this player's turn		
			(mouse_moves_allowed))									//	i.e. we are waiting for a human mouse click
			{
			mouseSemaphore->Acquire();								//	acquire the mouse semaphore
			mouse_moves_allowed = false;							//	prohibit mouse moves
			mouseSemaphore->Release();								//	release the mouse semaphore
			turnSemaphore->Acquire();								//	acquire the turn semaphore
			thePlayerIsHuman = false;								//	mark it as no longer human (force it to think)
			turnSemaphore->Release();								//	release the turn semaphore
			} 
		bluePlayerType = playerType;
		} // end of blue player
	} // end of SetPlayerType()

void CMassView::ToggleSound()										//	toggles sound on/off
	{
	soundOn = !soundOn;												//	just invert it
	} // end of ToggleSound

void CMassView::SetDisplaySpeed(long newOption)						//	sets the speed of display
	{
	speedID = newOption;											//	reset the option
	switch (speedID)												//	then, depending on what it is
		{
		case OptionFastDisplayItem:
			displaySpeed = FAST_SPEED;
			break;	
		case OptionMediumDisplayItem:
			displaySpeed = MEDIUM_SPEED;
			break;	
		case OptionSlowDisplayItem:
			displaySpeed = SLOW_SPEED;
			break;	
		} // end of switch
	} // end of SetDisplaySpeed
	
void CMassView::NewGame(bool restart)								//	reset for a new game
	{
	// make sure that the Looper is the only thread out there
	// we don't care about errors - the following threads may or may not exist
	kill_thread(displayThread);										//	kill the display thread
	kill_thread(thinkingThread);									//	kill the thinking thread
	// since we know that there are no other threads, we dispose of the semaphores and reacquire them
	
	if (theBrain != NULL)											//	if there is one
		theBrain->kill_threads();									//	kill its threads

	delete displayBoardSemaphore;									//	delete them one at a time
	delete displaySemaphore;
	delete mouseSemaphore;
	delete turnSemaphore;
	delete thinkingSemaphore;
		
	displayBoardSemaphore = new CMSemaphore(DISPLAYBOARDSEMNAME);	//	re-initialize our semaphores
	displaySemaphore = new CMSemaphore(DISPLAYSEMNAME);				
	mouseSemaphore = new CMSemaphore(MOUSESEMNAME);
	turnSemaphore = new CMSemaphore(TURNSEMNAME);
	thinkingSemaphore = new CMSemaphore(THINKINGSEMNAME);	
	
	theBoard = new CMBoard();										//	make a blank board
	theDisplayBoard = new CMBoard();								//	ditto for the display board
	thePlayer = RED_PLAYER;											//	set the first player
	thePlayerIsHuman = (redPlayerType == HUMAN_PLAYER);				//	set the humanity of player 1
	gameOver = false;												//	set flag
	gameTurn = 1;													//	set turn number
	delete theBrain;												//	get rid of any existing brain
	theBrain = NULL;												//	set this to a known value
	mouse_moves_allowed = thePlayerIsHuman;							//	set whether the initial move is a mouse move
	thinkingUpMove = false;											//	no move is being thought up
	displayDone = true;												//	we're done displaying
	busyWithMouseDown = false;										//	we're not busy, to start with
	winner = NEITHER_PLAYER;										//	and set it to nobody to start with
	if (restart)													//	if we are restarting
		theStatusBar->Reset();										//	reset the status bar
	} // end of NewGame()